<?php
session_start();
require_once('../../config/db_const.php');
require_once('../../config/class.Database.php');

$page_title = "گزارش مشتریان";
$db = new Database(DB_HOST,DB_USER,DB_PASSWORD,DB_NAME);
$db->connect();

if (isset($_SESSION['username']) && isset($_SESSION['password'])) {
?>

<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en" class="no-js">
<!--<![endif]-->
<!-- BEGIN HEAD -->
<head>
<meta charset="utf-8"/>
<title><?php echo $page_title;?></title>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta content="width=device-width, initial-scale=1" name="viewport"/>
<meta content="" name="description"/>
<meta content="" name="author"/>
<!-- BEGIN GLOBAL MANDATORY STYLES -->
<link href="../../assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/global/plugins/bootstrap/css/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/global/plugins/uniform/css/uniform.default.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/global/plugins/bootstrap-switch/css/bootstrap-switch-rtl.min.css" rel="stylesheet" type="text/css"/>
<!-- END GLOBAL MANDATORY STYLES -->
<!-- BEGIN PAGE LEVEL PLUGIN STYLES -->
<link href="../../assets/global/plugins/bootstrap-daterangepicker/daterangepicker-bs3.css" rel="stylesheet" type="text/css"/>
<!-- BEGIN PAGE LEVEL PLUGIN STYLES -->
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/select2/select2.css"/>
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/datatables/extensions/Scroller/css/dataTables.scroller.min.css"/>
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/datatables/extensions/ColReorder/css/dataTables.colReorder.min.css"/>
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap-rtl.css"/>
<link href="../../assets/global/plugins/bootstrap-daterangepicker/daterangepicker-bs3.css" rel="stylesheet" type="text/css"/>
<!-- END PAGE LEVEL PLUGIN STYLES -->
<!-- BEGIN PAGE LEVEL STYLES -->
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/select2/select2.css"/>
<link rel="stylesheet" type="text/css" href="../../assets/global/plugins/bootstrap-select.min.css" />
<!-- END PAGE LEVEL SCRIPTS -->
<!-- BEGIN THEME STYLES -->
<link href="../../assets/global/css/components-md-rtl.css" id="style_components" rel="stylesheet" type="text/css"/>
<link href="../../assets/global/css/plugins-md-rtl.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/admin/layout/css/layout-rtl.css" rel="stylesheet" type="text/css"/>
<link id="style_color" href="../../assets/admin/layout/css/themes/darkblue-rtl.css" rel="stylesheet" type="text/css"/>
<link href="../../assets/admin/layout/css/custom-rtl.css" rel="stylesheet" type="text/css"/>
<!-- END THEME STYLES -->
<link rel="shortcut icon" href="favicon.ico"/>
</head>
<!-- END HEAD -->
<!-- BEGIN BODY -->
<body class="page-md page-header-fixed page-quick-sidebar-over-content">

<?php require_once('header.php');?>

<div class="clearfix">
</div>
<!-- BEGIN CONTAINER -->
<div class="page-container">
	<!-- BEGIN SIDEBAR -->
	<?php
	$menu_selected="customers";
	require_once('sidebar.php');?>
	<!-- END SIDEBAR -->
	<!-- BEGIN CONTENT -->
	<div class="page-content-wrapper">
		<div class="page-content">
			<!-- BEGIN PAGE CONTENT-->
			<!--BEGIN PAGE HEADER-->
			<div class="page-bar">
				<ul class="page-breadcrumb">
					<li>
						<i class="fa fa-home"></i>
						<a href="index.php">صفحه اصلی</a>
						<i class="fa fa-angle-left"></i>
					</li>
					<li>
						<a href="customer_report.php">گزارش مشتریان</a>
					</li>
				</ul>
			</div>
			<!-- END PAGE HEADER-->
			<div class="row">
				<div class="col-md-12">
					<div class="portlet box blue" id="form_wizard_1">
						<div class="portlet-title">
							<div class="caption">
								<i class="fa fa-user"></i> گزارش مشتریان <span class="step-title"></span>
							</div>
							<div class="tools hidden-xs">
								<a href="javascript:;" class="collapse">
								</a>
							</div>
						</div>
						<div class="portlet-body form">
							<div class="row">
								<div class="col-md-12">
									<form action="<?php $_SERVER['PHP_SELF']?>" class="form-horizontal" id="submit_form" method="POST">
										<div class="form-wizard">
											<div class="form-body">
												<div class="tab-content">
													<div class="alert alert-danger display-none">
														<button class="close" data-dismiss="alert"></button>
														<!-- danger alert here -->
													</div>
													<div class="alert alert-success display-none">
														<button class="close" data-dismiss="alert"></button>
														<!-- success alert here -->
													</div>
													<div class="tab-pane active" id="tab1">
														<h3 class="block">جستجوی مشتری</h3>
                                                        <br />
                                                        <div class="form-group">
                                                            <div class="col-md-4">
																<select id="opt" class="form-control select2me" data-live-search="true">
																	<option class="dropdown-list" value=""> جستجو بر اساس</option>
                                                                    <!-- <option class="dropdown-list" value="سال">سال</option> -->
                                                                    <option class="dropdown-list" value="نام">نام</option>
                                                                    <option class="dropdown-list" value="حساب پولی">حساب پولی</option>
																</select>
																<span class="help-block">
																</span>
															</div>
                                                        </div>
														<!-- <div class="form-group" id="year-opt">
															<div class="col-md-2">
																<select class="form-control select2me" data-live-search="true" name="year">
																	<option class="dropdown-list" value="">سال</option>
																	<?php
																		for ($i=1380; $i < 1420 ; $i++) { 
																			echo '<option class="dropdown-list" value="'. $i .'">' .$i. '</option>';
																		}
																	?>
																</select>
																<span class="help-block">
																</span>
															</div>
                                                            <div class="col-md-1">
																<div class="button_wrapper">
																	<div class="row">
																		<div class="col-md-offset-3 col-md-4">
																			<input type="submit" value="&nbsp;&nbsp;جستجو&nbsp;&nbsp;" class="btn green button-submit" name="year_submit"/>
																		</div>
																	</div>
																</div>
															</div>
                                                        </div> -->
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
                            <div class="row" id="name-opt">
								<div class="col-md-12">
									<form action="<?php $_SERVER['PHP_SELF']?>" class="form-horizontal" id="submit_form" method="POST">
										<div class="form-wizard">
											<div class="form-body">
												<div class="tab-content">
													<div class="tab-pane active" id="tab1">
														<div class="form-group">
															<div class="col-md-2">
																<input type="text" name="name" class="form-control" placeholder="نام">
															</div>
															<div class="col-md-1">
																<div class="button_wrapper">
																	<div class="row">
																		<div class="col-md-offset-3 col-md-4">
																			<input type="submit" value="&nbsp;&nbsp;جستجو&nbsp;&nbsp;" class="btn green button-submit" name="name_submit"/>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
							<div class="row" id="unit-opt">
								<div class="col-md-12">
									<form action="<?php $_SERVER['PHP_SELF']?>" class="form-horizontal" id="submit_form" method="POST">
										<div class="form-wizard">
											<div class="form-body">
												<div class="tab-content">
													<div class="tab-pane active" id="tab1">
														<div class="form-group">
															<div class="col-md-2">
																<select class="form-control select2me" data-live-search="true" name="unit">
																	<option class="dropdown-list" value="">واحد پولی</option>
																	<?php
																		$result = $db->query("SELECT * FROM currencies");
																		if($result->num_rows > 0){
																			while($row = $result->fetch_assoc()){
																				echo '<option class="dropdown-list" value="'. $row['id'] .'">' .$row['unit']. '</option>';
																			}
                                                                            $result->free();
                                                                            unset($result);
																		}else{
																		}
																	?>
																</select>
																<span class="help-block">
																</span>
 															</div>															
															<div class="col-md-1">
																<div class="button_wrapper">
																	<div class="row">
																		<div class="col-md-offset-3 col-md-4">
																			<input type="submit" value="&nbsp;&nbsp;جستجو&nbsp;&nbsp;" class="btn green button-submit" name="unit_submit"/>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
							<!-- BEGIN PAGE CONTENT-->
							<div class="row">
								<div class="col-md-12">
									<!-- BEGIN EXAMPLE TABLE PORTLET-->
									<div class="table-wrapper">
										<hr class="horizontal-line" />
										<div class="portlet-body">
											<table class="table table-striped table-bordered table-hover" id="sample1">
											<thead>
											<tr>
												<th class="table-number">
													شماره
												</th>
												<th>
													نام
												</th>
												<th>
													شماره تذکره
												</th>
												<th>
													شماره تماس
												</th>
												<th>
													نوع حساب
												</th>
												<th>
													مقدار پول 
												</th>
												<th>
													پول به دالر 
												</th>
												<th>
													نوع معامله
												</th>
												<th>
													تاریخ
												</th>
												<th class="table-operation-header">
													ویرایش
												</th>
												<th class="table-operation-header">
													حذف
												</th>
											</tr>
											</thead>
											<tbody>
											<?php
												require_once('customer_report_queries.php');
											?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- END PAGE CONTENT-->
		</div>
	</div>
<!-- BEGIN FOOTER -->
<?php require_once('footer.php');?>
<!-- END FOOTER -->
</div>
<!-- BEGIN JAVASCRIPTS(Load javascripts at bottom, this will reduce page load time) -->
<!-- BEGIN CORE PLUGINS -->
<!--[if lt IE 9]>
<script src="../../assets/global/plugins/respond.min.js"></script>
<script src="../../assets/global/plugins/excanvas.min.js"></script> 
<![endif]-->
<script src="../../assets/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<!-- IMPORTANT! Load jquery-ui.min.js before bootstrap.min.js to fix bootstrap tooltip conflict with jquery ui tooltip -->
<script src="../../assets/global/plugins/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/jquery.blockui.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/jquery.cokie.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/uniform/jquery.uniform.min.js" type="text/javascript"></script>
<script src="../../assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
<!-- END CORE PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script type="text/javascript" src="../../assets/global/plugins/select2/select2.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/datatables/media/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/datatables/extensions/TableTools/js/dataTables.tableTools.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/datatables/extensions/ColReorder/js/dataTables.colReorder.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/datatables/extensions/Scroller/js/dataTables.scroller.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script type="text/javascript" src="../../assets/global/plugins/jquery-validation/js/jquery.validate.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/jquery-validation/js/additional-methods.min.js"></script>
<script type="text/javascript" src="../../assets/global/plugins/bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL PLUGINS -->
<script type="text/javascript" src="../../assets/global/plugins/select2/select2.min.js"></script>
<script src="../../assets/global/plugins/bootstrap-select.min.js"></script>
<!-- END PAGE LEVEL PLUGINS -->
<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="../../assets/global/scripts/metronic.js" type="text/javascript"></script>
<script src="../../assets/admin/layout/scripts/layout.js" type="text/javascript"></script>
<script src="../../assets/admin/layout/scripts/demo.js" type="text/javascript"></script>
<script src="../../assets/admin/pages/scripts/table-advanced.js"></script>
<script src="../../assets/admin/pages/scripts/form-wizard.js"></script>
<!-- END PAGE LEVEL SCRIPTS -->
<script>
jQuery(document).ready(function() {
	//hide all report forms
    $('#year-opt,#name-opt,#unit-opt').hide();
    
    //show report form based on selection
    $('#opt').change(function(){
        var opt = $('#opt').val();
        switch(opt){
            case 'سال':
                $('#year-opt').show();
                $('#name-opt,#unit-opt').hide();
                break;
            case 'نام':
                $('#name-opt').show();
                $('#year-opt,#unit-opt').hide();
                break;
            case 'حساب پولی':
                $('#unit-opt').show();
                $('#year-opt,#name-opt').hide();
                break; 
            default:
                $('#year-opt,#name-opt,#unit-opt').hide();
        }  
    });
	
	$('.selectpicker').selectpicker({
		style: 'btn-alert',
		size: 6
	});        
   // initiate layout and plugins
   Metronic.init(); // init metronic core components
   Layout.init(); // init current layout
   Demo.init(); // init demo features
   TableAdvanced.init();
   FormWizard.init(); 
});
</script>

<!-- END JAVASCRIPTS -->
</body>
<!-- END BODY -->
</html>
<?php
}else{
	header("Location: login.php");
}
?>